/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ArrUtils;
import com.gitlab.srcmc.rctmod.client.renderer.TargetArrowRenderer;
import com.gitlab.srcmc.rctmod.client.renderer.TrainerAssociationRenderer;
import com.gitlab.srcmc.rctmod.client.renderer.TrainerRenderer;
import com.gitlab.srcmc.rctmod.client.screens.IScreenManager;
import com.gitlab.srcmc.rctmod.client.screens.ScreenManager;
import com.gitlab.srcmc.rctmod.network.PlayerStatePayload;
import com.gitlab.srcmc.rctmod.network.TrainerTargetPayload;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_746;

public class ModClient {
    public static final IScreenManager SCREENS = new ScreenManager();
    private static Queue<byte[]> playerStateUpdates = new ConcurrentLinkedDeque<byte[]>();
    static List<byte[]> PLAYER_STATE_PAYLOADS = new ArrayList<byte[]>();

    public static void init() {
        class_310 mc = class_310.method_1551();
        ModCommon.initPlayer(() -> mc.field_1724);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)RCTMod.getInstance().getClientDataManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)RCTMod.getInstance().getTrainerManager());
        EntityRendererRegistry.register(ModRegistries.Entities.TRAINER, TrainerRenderer::new);
        EntityRendererRegistry.register(ModRegistries.Entities.TRAINER_ASSOCIATION, TrainerAssociationRenderer::new);
        TargetArrowRenderer.init();
    }

    public static void setup() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, PlayerStatePayload.TYPE, PlayerStatePayload.CODEC, ModClient::receivePlayerState);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, TrainerTargetPayload.TYPE, TrainerTargetPayload.CODEC, ModClient::receiveTrainerTarget);
        ClientTickEvent.CLIENT_LEVEL_POST.register(ModClient::onClientLevelTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ModClient::onClientPlayerJoin);
    }

    static void onClientLevelTick(class_1937 level) {
        byte[] psu;
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (tm.isReloadRequired()) {
            tm.loadTrainers();
        }
        if ((psu = playerStateUpdates.poll()) != null) {
            PlayerState.get(ModCommon.localPlayer()).deserializeUpdate(psu);
        }
        TargetArrowRenderer.getInstance().tick();
    }

    static void onClientPlayerJoin(class_746 player) {
        PLAYER_STATE_PAYLOADS.clear();
        PlayerState.initFor((class_1657)player);
    }

    static void receivePlayerState(PlayerStatePayload pl, NetworkManager.PacketContext context) {
        PLAYER_STATE_PAYLOADS.add(pl.bytes());
        if (pl.remainingBatches() == 0) {
            if (!playerStateUpdates.offer(ArrUtils.combine(PLAYER_STATE_PAYLOADS))) {
                ModCommon.LOG.error("Failed to store player state updates");
            }
            PLAYER_STATE_PAYLOADS.clear();
        }
    }

    static void receiveTrainerTarget(TrainerTargetPayload tt, NetworkManager.PacketContext context) {
        TargetArrowRenderer.getInstance().setTarget((class_1297)context.getPlayer(), new class_243(tt.targetX(), tt.targetY(), tt.targetZ()), tt.otherDim());
    }
}

